/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;

public class ModifyPatchedShaderpacks {
    public static void modifyShadersProperties(Path patchedFile, boolean styleUnbound, boolean styleReimagined, String ... regexAndReplacements) throws IOException {
        if (regexAndReplacements.length % 2 != 0) {
            EuphoriaPatcher.log(2, 0, "Regex and replacement pairs must be provided");
        }
        ModifyPatchedShaderpacks.processShaderPacks(patchedFile, styleUnbound, styleReimagined, shaderPack -> {
            try {
                Path shadersPropertiesPath = shaderPack.resolve("shaders/shaders.properties");
                String content = new String(Files.readAllBytes(shadersPropertiesPath));
                String modifiedContent = ModifyPatchedShaderpacks.applyReplacements(content, regexAndReplacements);
                Files.write(shadersPropertiesPath, modifiedContent.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(2, 0, "Error processing shader properties " + shaderPack.getFileName() + ": " + e.getMessage());
            }
        });
    }

    public static void modifyLangFiles(Path patchedFile, boolean styleUnbound, boolean styleReimagined, String ... regexAndReplacements) throws IOException {
        if (regexAndReplacements.length % 2 != 0) {
            EuphoriaPatcher.log(2, 0, "Regex and replacement pairs must be provided");
        }
        ModifyPatchedShaderpacks.processShaderPacks(patchedFile, styleUnbound, styleReimagined, shaderPack -> {
            try {
                Path langDirectory = shaderPack.resolve("shaders/lang");
                try (DirectoryStream<Path> langFiles = Files.newDirectoryStream(langDirectory, "*.lang");){
                    for (Path langFile : langFiles) {
                        String content = new String(Files.readAllBytes(langFile));
                        String modifiedContent = ModifyPatchedShaderpacks.applyReplacements(content, regexAndReplacements);
                        Files.write(langFile, modifiedContent.getBytes(), new OpenOption[0]);
                    }
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(2, 0, "Error processing lang files " + shaderPack.getFileName() + ": " + e.getMessage());
            }
        });
    }

    private static void processShaderPacks(Path patchedFile, boolean styleUnbound, boolean styleReimagined, Consumer<Path> processor) {
        List<Path> shaderPacks = ModifyPatchedShaderpacks.getShaderPacks(patchedFile, styleUnbound, styleReimagined);
        for (Path shaderPack : shaderPacks) {
            if (!Files.exists(shaderPack, new LinkOption[0])) continue;
            processor.accept(shaderPack);
        }
    }

    private static String applyReplacements(String content, String ... regexAndReplacements) {
        String modifiedContent = content;
        for (int i = 0; i < regexAndReplacements.length; i += 2) {
            String regex = regexAndReplacements[i];
            String replacement = regexAndReplacements[i + 1];
            modifiedContent = modifiedContent.replaceAll(regex, replacement);
        }
        return modifiedContent;
    }

    private static List<Path> getShaderPacks(Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        ArrayList<Path> shaderPacks = new ArrayList<Path>();
        shaderPacks.add(patchedFile);
        if (styleUnbound && styleReimagined) {
            Path otherStylePath;
            Path path = otherStylePath = patchedFile.getFileName().toString().contains("Reimagined") ? patchedFile.resolveSibling(patchedFile.getFileName().toString().replace("Reimagined", "Unbound")) : patchedFile.resolveSibling(patchedFile.getFileName().toString().replace("Unbound", "Reimagined"));
            if (Files.exists(otherStylePath, new LinkOption[0])) {
                shaderPacks.add(otherStylePath);
            }
        }
        return shaderPacks;
    }
}

